﻿@imports Resources
@ModelType UserPoco
@Code
    ViewData("Title") = Strings.Admin_Create_Title
End Code

<div class="container mt-4" style="max-width: 800px;">
    <h2>@Strings.Admin_Create_Title</h2>
    <hr />

    @Using (Html.BeginForm())
        @Html.AntiForgeryToken()
        @Html.ValidationSummary(True, "", New With {.class = "text-danger"})

        @* Login Name *@
        @<div class="mb-3 row">
            @Html.LabelFor(Function(model) model.LoginName, Strings.Admin_Create_DomainLoginName_Label, New With {.class = "col-sm-3 col-form-label fw-bold"})
            <div class="col-sm-9">
                @Html.EditorFor(Function(model) model.LoginName, New With {.htmlAttributes = New With {.class = "form-control"}})
                @Html.ValidationMessageFor(Function(model) model.LoginName, "", New With {.class = "text-danger"})
            </div>
        </div>

        @* Is Portal Admin Checkbox *@
        @<div class="mb-3 row">
            <div class="col-sm-9 offset-sm-3">
                <div class="form-check">
                    @Html.CheckBoxFor(Function(model) model.IsWOLPortalAdmin, New With {.class = "form-check-input"})
                    @Html.LabelFor(Function(model) model.IsWOLPortalAdmin, Strings.Admin_Create_IsPortalAdmin_Label, New With {.class = "form-check-label"})
                    @Html.ValidationMessageFor(Function(model) model.IsWOLPortalAdmin, "", New With {.class = "text-danger"})
                </div>
            </div>
        </div>

        @* Is Group Status Viewer Checkbox *@
        @<div class="mb-3 row">
            <div class="col-sm-9 offset-sm-3">
                <div class="form-check">
                    @Html.CheckBoxFor(Function(model) model.IsGroupDataReader, New With {.class = "form-check-input"})
                    @Html.LabelFor(Function(model) model.IsGroupDataReader, Strings.Admin_Create_IsGroupStatusViewer_Label, New With {.class = "form-check-label"})
                    @Html.ValidationMessageFor(Function(model) model.IsGroupDataReader, "", New With {.class = "text-danger"})
                </div>
            </div>
        </div>

        @* Submit Button *@
        @<div class="mb-3 row">
            <div class="col-sm-9 offset-sm-3">
                <input type="submit" value="@Strings.Admin_Create_SubmitButton_Text" class="btn btn-primary" />
            </div>
        </div>
    End Using

    <div class="mt-4">
        @Html.ActionLink(Strings.Admin_Create_BackToList_Link_Text, "Index", Nothing, New With {.class = "btn btn-secondary"})
    </div>
</div>

@Section Scripts
    @Scripts.Render("~/bundles/jqueryval")
End Section