﻿@imports Resources
@ModelType UserPoco
@Code
    ViewData("Title") = Strings.EditUser_ViewTitle
End Code

<div class="container mt-4" style="max-width: 900px;">
    <h2>@Strings.EditUser_Header <span class="text-primary">@Model.LoginName</span></h2>
    <hr />

    @Using (Html.BeginForm("Edit", "Admin"))
        @Html.AntiForgeryToken()
        @Html.ValidationSummary(True, "", New With {.class = "text-danger"})
        @Html.HiddenFor(Function(model) model.ID)
        @Html.HiddenFor(Function(model) model.LastLoginTimeStamp)

        @* --- USER DETAILS CARD --- *@
        @<div class="card mb-4">
            <div class="card-header fw-bold">
                @Strings.EditUser_UserPropertiesCardHeader
            </div>
            <div class="card-body">
                @* Login Name *@
                <div class="mb-3 row">
                    @Html.LabelFor(Function(model) model.LoginName, Strings.EditUser_LoginNameLabel, New With {.class = "col-sm-3 col-form-label"})
                    <div class="col-sm-9">
                        @Html.EditorFor(Function(model) model.LoginName, New With {.htmlAttributes = New With {.class = "form-control"}})
                        @Html.ValidationMessageFor(Function(model) model.LoginName, "", New With {.class = "text-danger"})
                    </div>
                </div>

                @* Checkboxes *@
                <div class="mb-3 row">
                    <div class="col-sm-9 offset-sm-3">
                        <div class="form-check mb-2">
                            @Html.CheckBoxFor(Function(model) model.IsWOLPortalAdmin, New With {.class = "form-check-input"})
                            @Html.LabelFor(Function(model) model.IsWOLPortalAdmin, Strings.EditUser_IsPortalAdminLabel, New With {.class = "form-check-label"})
                        </div>
                        <div class="form-check">
                            @Html.CheckBoxFor(Function(model) model.IsGroupDataReader, New With {.class = "form-check-input"})
                            @Html.LabelFor(Function(model) model.IsGroupDataReader, Strings.EditUser_IsStatusViewerLabel, New With {.class = "form-check-label"})
                        </div>
                    </div>
                </div>
            </div>
        </div>

        @* --- ASSIGNED PCs CARD --- *@
        @<div class="card">
            <div class="card-header d-flex justify-content-between align-items-center fw-bold">
                @Strings.EditUser_ManageAssignedPCsCardHeader
                @Html.ActionLink(Strings.EditUser_AddPCLink, "ADDPC1", New With {.userID = Model.ID}, New With {.class = "btn btn-sm btn-success"})
            </div>
            <div class="card-body p-0">
                @* p-0 to make table flush with card edges *@
                @If Model.PCs IsNot Nothing AndAlso Model.PCs.Any() Then
                    @<table class="table table-striped table-hover mb-0 align-middle">
                        <thead class="table-light">
                            <tr>
                                <th style="width: 60%;">@Strings.EditUser_PCNameTableHeader</th>
                                <th class="text-center">@Strings.EditUser_EnabledTableHeader</th>
                                <th class="text-end">@Strings.EditUser_ActionsTableHeader</th>
                            </tr>
                        </thead>
                        <tbody>
                            @Code
                                ' Use a For loop with an index for model binding to work on postback
                                For i As Integer = 0 To Model.PCs.Count - 1
                                    Dim pcID As Integer = Model.PCs(i).ID
                                    @<tr>
                                        <td>
                                            @Html.HiddenFor(Function(m) m.PCs(i).ID)
                                            @Html.HiddenFor(Function(m) m.PCs(i).UserID)
                                            @Html.TextBoxFor(Function(m) m.PCs(i).PCName, New With {.class = "form-control", .placeholder = Strings.EditUser_PCNamePlaceholder})
                                            @Html.ValidationMessageFor(Function(m) m.PCs(i).PCName, "", New With {.class = "text-danger"})
                                        </td>
                                        <td class="text-center">
                                            <div class="form-check d-inline-block">
                                                @Html.CheckBoxFor(Function(m) m.PCs(i).Enabled, New With {.class = "form-check-input"})
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            @If pcID > 0 Then
                                                @Html.ActionLink(Strings.EditUser_DeletePCLink, "DELPC", New With {.pcID = pcID}, New With {.class = "btn btn-sm btn-outline-danger"})
                                            End If
                                        </td>
                                    </tr>
                                Next
                            End Code
                        </tbody>
                    </table>
                                Else
                    @<div class="p-3 text-center text-muted">
                        @Strings.EditUser_NoPCsAssignedMessage
                    </div>
                                End If
            </div>
        </div>

        @* --- ACTION BUTTONS (New Version) --- *@
        @<div class="mt-4">
            <input type="submit" name="submitButton" value="@Strings.EditUser_SaveAndCloseButton" class="btn btn-primary" />
            <input type="submit" name="submitButton" value="@Strings.EditUser_ApplyButton" class="btn btn-info ms-2" />
            @Html.ActionLink(Strings.EditUser_BackButton, "Index", Nothing, New With {.class = "btn btn-secondary ms-2"})
        </div>
                                End Using
</div>

@Section Scripts
    @Scripts.Render("~/bundles/jqueryval")
End Section