﻿@Imports Resources
@ModelType UserPoco
@Code
    ViewData("Title") = Strings.Login_Title
    Layout = "~/Views/Shared/_Layout.vbhtml"
    Dim state As String = ViewBag.State
    Dim showSamlLogin As Boolean = If(ViewBag.ShowSamlLoginLink IsNot Nothing, ViewBag.ShowSamlLoginLink, False)
End Code

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-10 col-lg-8 col-xl-7">
  <div class="card mt-5 shadow-sm">
     <div class="card-header text-center bg-light">

         @If showSamlLogin Then
      @<text>
          <h4 Class="mb-0">@Strings.Login_WakePCs</h4>
          </text>
         Else
    @<text>
     <h4 Class="mb-0">@Strings.Login_PleaseAuthorize</h4>
     </text>
         End If

     </div>
       <div class="card-body p-4">

        @* Show any login error messages here *@
   @If Not String.IsNullOrWhiteSpace(state) Then
     @<div class="alert alert-danger text-center">
 @state
   </div>
       End If

       @If showSamlLogin Then
              @* --- SAML First Experience (New and Improved Wording) --- *@
    @<div class="text-center">
   <h5 class="card-title">  </h5>
   <p class="text-muted">

  </p>
       @* ActionLink updated with an icon and compelling text *@
        @Html.ActionLink(Strings.Login_StartWakeup, "Login", "Auth", Nothing, New With {.class = "btn btn-primary btn-lg w-100 mt-2"})
    </div>

         @<div class="my-4 d-flex align-items-center">
   <hr class="flex-grow-1" />
   <span class="mx-2 text-muted">@Strings.Login_Or</span>
     <hr class="flex-grow-1" />
    </div>

     @<div class="text-center">
    @* The link to the alternative is now much clearer *@
   <a data-bs-toggle="collapse" href="#collapseLoginForm" role="button" aria-expanded="false" aria-controls="collapseLoginForm" class="text-decoration-none">
  @Strings.Login_SpecialLogin
    </a>
    </div>

@<div class="collapse mt-3" id="collapseLoginForm">
   @* The standard form is unchanged, just hidden by default *@
         @Html.Partial("_StandardLoginForm", Model)
   </div>

   Else
      @* --- Standard Login Only Experience (No Changes Needed Here) --- *@
        @Html.Partial("_StandardLoginForm", Model)
    End If

</div>
     </div>
 </div>
    </div>
</div>