@Imports Resources
@ModelType SharedMessageViewModel
@Code
    ViewData("Title") = If(String.IsNullOrEmpty(Model.Title), "Strings.SharedMessage_Notification", Model.Title)
    Dim alertClass As String = "alert-info" ' Default to info
    If Not String.IsNullOrEmpty(Model.MessageType) Then
        alertClass = "alert-" & Model.MessageType.ToLower()
    End If
End Code

<div Class="container">
    <div Class="row">
        <div Class="col-md-8 col-md-offset-2 text-center">
            <div Class="alert @alertClass" role="alert">
                <h4 Class="alert-heading">@ViewData("Title")</h4>
                <p>@Model.Message</p>
                @If Not String.IsNullOrEmpty(Model.ReturnAction) AndAlso Not String.IsNullOrEmpty(Model.ReturnController) Then
                    @<hr />
                    @<p Class="mb-0">
                        @Using Html.BeginForm(Model.ReturnAction, Model.ReturnController, FormMethod.Post, New With {.style = "display:inline;"})
                            @Html.AntiForgeryToken()
                            @<button type="submit" Class="btn btn-primary">@(If(String.IsNullOrEmpty(Model.ReturnActionText), "Strings.SharedMessage_GoBack", Model.ReturnActionText))</button>
                        End Using
                    </p>
                End If
            </div>
        </div>
    </div>
</div>
