﻿@Imports Resources
@ModelType WEBPortal.ViewModels.StatusViewModel
@Code
    ViewData("Title") = Strings.Status_Title
End Code

<div class="container mt-4">
    <div class="card" style="max-width: 900px; margin: auto;">
        <div class="card-header">
            <h4 class="mb-0">@Strings.Status_GroupStatusOverview</h4>
            <small class="text-muted">@Strings.Status_GeneratedOn @Model.GeneratedTimestamp</small>
        </div>

        <div class="card-body">
            @* --- OVERALL SUMMARY SECTION --- *@
            <h5 class="card-title">@Strings.Status_OverallStatistics</h5>
            <div class="row align-items-center mb-4">
                <div class="col-md-6">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @Strings.Status_TotalComputers
                            <span class="badge bg-primary rounded-pill fs-6">@Model.TotalPcCount</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @Strings.Status_CurrentlyOnline
                            <span class="badge bg-success rounded-pill fs-6">@Model.TotalOnlineCount</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            @Strings.Status_CurrentlyOffline
                            <span class="badge bg-secondary rounded-pill fs-6">@Model.TotalOfflineCount</span>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <strong>@Strings.Status_OnlinePercentage</strong>
                        <div class="progress mt-2" style="height: 30px;">
                            <div class="progress-bar bg-success progress-bar-striped progress-bar-animated" role="progressbar" style="width: @(Model.OverallOnlinePercentageRaw)%;" aria-valuenow="@Model.OverallOnlinePercentageRaw" aria-valuemin="0" aria-valuemax="100">
                                <b class="fs-6">@Model.OverallOnlinePercentageFormatted</b>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <hr />

            @* --- DETAILED GROUP TABLE --- *@
        <h5 class="card-title mt-4">@Strings.Status_StatusByPolicyGroup</h5>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>@Strings.Status_GroupName</th>
                            <th style="width: 50%;">@Strings.Status_OnlineStatus</th>
                        </tr>
                    </thead>
                    <tbody>
                        @If Model.GroupDetailsList.Any() Then
                            For Each item In Model.GroupDetailsList
                                @<tr>
                                    <td>
                                        <strong>@item.GroupName</strong>
                                        <br />
                                        <small class="text-muted">(@item.OnlinePcs / @item.TotalPcs @Strings.Status_PCsOnline)</small>
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 25px;">
                                            <div class="progress-bar bg-success" role="progressbar" style="width: @(item.RawOnlinePercentage)%;" aria-valuenow="@item.RawOnlinePercentage" aria-valuemin="0" aria-valuemax="100">
                                                @item.FormattedOnlinePercentage
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            Next
                        Else
                            @<tr>
                                <td colspan="2" class="text-center text-muted fst-italic py-3">@Strings.Status_NoGroupData</td>
                            </tr>
                        End If
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card-footer bg-light d-flex justify-content-between align-items-center">
            <div>
                @Html.ActionLink(Strings.Status_BackToWOLPortal, "Wol", "Home", Nothing, New With {.class = "btn btn-secondary btn-sm"})
            </div>
            <div>
                @Using (Html.BeginForm("Logout", "Home", FormMethod.Post, New With {.style = "display:inline;"}))
                    @Html.AntiForgeryToken()
                    @<button type="submit" class="btn btn-outline-danger btn-sm">@Strings.Status_Logout</button>
                End Using
            </div>
        </div>
    </div>
    @*<div class="text-center mt-3">
        <small class="text-muted">@Strings.Status_WOLPortalVersion @Model.AppVersion</small>
    </div>*@
</div>